package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.ContactData;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.ng.entities.TbContactNG;

/**
 * Created by rmemoria on 14/9/17.
 */
public class ContactConsumer extends SyncDataConsumerImpl<ContactData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ContactData data) {
        TbContactNG cont = recoverEntity(TbContactNG.class, data.getServerId());

        if (cont.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            cont.setTbcase(tbcase);
        }

        cont.setName(data.getFirstName());
        cont.setContactOtherName(data.getOtherName());
        cont.setContactLastName(data.getLastName());
        cont.setGender(data.getGender());
        cont.setAge(data.getAge());
        cont.setContactType(getFieldValue(data.getContactTypeId()));
        cont.setExaminated(data.isExaminated());
        cont.setDateOfExamination(data.getDateOfExamination());
        cont.setHasTB(data.isHasTB());
        cont.setStartedAntiTB(data.isStartedAntiTB());
        cont.setEligibleForINH(data.isEligibleForINH());
        cont.setCommencedOnINH(data.isCommencedOnINH());
        cont.setConduct(getFieldValue(data.getConductId()));
        cont.setComments(data.getComments());

        getEntityManager().persist(cont);

        return data.getServerId() == null ? cont.getId() : null;
    }
}
